local c;
local player = Var "Player";

-- blah
local JudgeCmds = {
	TapNoteScore_W1 = GetJudgmentCommand("W1");
	TapNoteScore_W2 = GetJudgmentCommand("W2");
	TapNoteScore_W3 = GetJudgmentCommand("W3");
	TapNoteScore_W4 = GetJudgmentCommand("W4");
	TapNoteScore_W5 = GetJudgmentCommand("W5");
	TapNoteScore_Miss = GetJudgmentCommand("Miss");
};

local ProtimingCmds = {
	TapNoteScore_W1 = THEME:GetMetric( "Protiming", "ProtimingW1Command" );
	TapNoteScore_W2 = THEME:GetMetric( "Protiming", "ProtimingW2Command" );
	TapNoteScore_W3 = THEME:GetMetric( "Protiming", "ProtimingW3Command" );
	TapNoteScore_W4 = THEME:GetMetric( "Protiming", "ProtimingW4Command" );
	TapNoteScore_W5 = THEME:GetMetric( "Protiming", "ProtimingW5Command" );
	TapNoteScore_Miss = THEME:GetMetric( "Protiming", "ProtimingMissCommand" );
};

local TNSFrames = {
	TapNoteScore_W1 = 0;
	TapNoteScore_W2 = 1;
	TapNoteScore_W3 = 2;
	TapNoteScore_W4 = 3;
	TapNoteScore_W5 = 4;
	TapNoteScore_Miss = 5;
};
-- end blah

local judgeType, showTicks = "Normal", false
if ThemePrefs.Get("JudgeStyle") ~= nil then judgeType = ThemePrefs.Get("JudgeStyle") end
if ThemePrefs.Get("JudgeTicks") ~= nil then showTicks = ThemePrefs.Get("JudgeTicks") end

-- handle tick x positions
local ticksNormal = {
	Normal = {
		TapNoteScore_W2 = 80,
		TapNoteScore_W3 = 60,
		TapNoteScore_W4 = 52,
		TapNoteScore_W5 = 42,
	},
	["sm-ssc"] = {
		TapNoteScore_W2 = 76,
		TapNoteScore_W3 = 58,
		TapNoteScore_W4 = 56,
		TapNoteScore_W5 = 42,
	},
	Classic = {
		TapNoteScore_W2 = 76,
		TapNoteScore_W3 = 54,
		TapNoteScore_W4 = 44,
		TapNoteScore_W5 = 38,
	},
	Groovy = {
		TapNoteScore_W2 = 96,
		TapNoteScore_W3 = 58,
		TapNoteScore_W4 = 64,
		TapNoteScore_W5 = 70,
	},
}

local t = Def.ActorFrame {
	LoadActor(THEME:GetPathG("JudgeTicks",judgeType)) .. {
		Name="Ticks";
		InitCommand=cmd(pause;visible,false);
		OnCommand=THEME:GetMetric("Judgment","JudgmentOnCommand");
		ResetCommand=cmd(finishtweening;stopeffect;visible,false);
	};
	LoadActor(THEME:GetPathG("Judgment",judgeType)) .. {
		Name="Judgment";
		InitCommand=cmd(pause;visible,false);
		OnCommand=THEME:GetMetric("Judgment","JudgmentOnCommand");
		ResetCommand=cmd(finishtweening;stopeffect;visible,false);
	};

	-- todo: hook this bitch up
	LoadFont("_orbitron Bold 32px") .. {
		Name="ProtimingDisplay";
		InitCommand=cmd(visible,false);
		OnCommand=THEME:GetMetric("Protiming","ProtimingOnCommand");
		ResetCommand=cmd(finishtweening;stopeffect;visible,false);
	};

	InitCommand = function(self) c = self:GetChildren(); end;

	JudgmentMessageCommand=function(self, param)
		if param.Player ~= player then return end;
		if param.HoldNoteScore then return end;

		local iNumStates = c.Judgment:GetNumStates();
		local iFrame = TNSFrames[param.TapNoteScore];

		local iTapNoteOffset = param.TapNoteOffset;

		if not iFrame then return end
		if iNumStates == 12 then
			iFrame = iFrame * 2;
			if not param.Early then iFrame = iFrame + 1; end
		end

		self:playcommand("Reset");

		c.Judgment:visible( true );
		c.Judgment:setstate( iFrame );
		JudgeCmds[param.TapNoteScore](c.Judgment);

		-- handle ticks
		if showTicks then
			if param.TapNoteScore ~= 'TapNoteScore_W1' and param.TapNoteScore ~= 'TapNoteScore_Miss' then
				-- show ticks
				local mul = param.Early and -1 or 1
				c.Ticks:visible(true)
				c.Ticks:setstate(iFrame);

				local tickPos = mul*ticksNormal[judgeType][param.TapNoteScore]
				if judgeType == "Normal" then
					if param.TapNoteScore == 'TapNoteScore_W2' and not param.Early then
						tickPos = tickPos + 4
					end
				end
				c.Ticks:x( tickPos )
				JudgeCmds[param.TapNoteScore](c.Ticks);
			else
				-- don't show on W1/Miss
				c.Ticks:visible(false)
			end
		end

--~ 	c.ProtimingDisplay:visible( true );
		c.ProtimingDisplay:settext( math.floor(math.abs(param.TapNoteOffset * 1000)) );
		ProtimingCmds[param.TapNoteScore](c.ProtimingDisplay);
	end;
};

return t;
